<?php
/**
* Plugin Name: Hosted Power Helper plugin
* Plugin URI: https://www.hosted-power.com/
* Description: Some extra functions needed for the site - DO NOT DEACTIVATE!
* Version: 1.2
* Author: Jo Goossens
* Author URI:  https://www.hosted-power.com/
**/


/**
 * Make sure https server header is set when needed
 *
 */
if ( isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https')
     $_SERVER['HTTPS']='on';

/**
 * Directly speak to our local varnish listener
 *
 */
function wp_rocket_change_varnish_ip( $ips ) {

	if ( ! is_array( $ips ) ) {
        	$ips = (array) $ips;
    	}

	$ips[] = '127.0.0.1:6081';	// Enter your custom Varnish IP here
	return $ips;
}
add_filter( 'rocket_varnish_ip', 'wp_rocket_change_varnish_ip' );

/**
 * Disable cookies since they disable cache
 * 
 * mailchimp_user_email
 * mailchimp_landing_site
 * mailchimp_campaign_id
 * mailchimp_user_previous_email
 * the cookie name will be whatever we're trying to set. return true if allowed, false if not allowed.
 */
function custom_cookie_callback_function($cookie_name) {

    if($cookie_name == 'mailchimp_landing_site'){
         return false;
    }

    return true;
}

add_filter( 'mailchimp_allowed_to_use_cookie', 'custom_cookie_callback_function', 10, 1 );


